#extension GL_EXT_draw_buffers : enable

precision mediump float;

uniform sampler2D 	texture_diffuse;
uniform sampler2D 	texture_ramp;
uniform float		u_alpha;

varying vec2 		v_uv;

void main()
{
    // Fetch Fragments Normal + Diffuse textures
    vec4 diffuse = texture2D( texture_diffuse, v_uv);

    // Write to albedo buffer only
	vec4 fVal = texture2D(texture_ramp, vec2(diffuse.x, 0.5));
	float fAlpha = fVal.w * u_alpha;
    gl_FragData[0] =  vec4( fVal.xyz, fAlpha);
	gl_FragData[1] = vec4(0.5,0.5,1.0, fAlpha*0.5);
}
